/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.util.StringUtil;
import com.aptana.js.core.inferencing.IRequireResolver;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSStringNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonJSResolver
implements IRequireResolver {
    @Override
    public IPath resolve(String moduleId, IProject project, IPath currentLocation, IPath indexRoot) {
        if (currentLocation == null || !currentLocation.toFile().isDirectory()) {
            throw new IllegalArgumentException("current location must be a directory");
        }
        if (indexRoot == null || !indexRoot.toFile().isDirectory()) {
            throw new IllegalArgumentException("module namespace root must be a directory");
        }
        IPath modulePath = Path.fromPortableString((String)moduleId);
        if (modulePath.getFileExtension() == null) {
            modulePath = modulePath.addFileExtension("js");
        }
        if (moduleId.startsWith(".")) {
            return currentLocation.append(modulePath);
        }
        return indexRoot.append(modulePath);
    }

    @Override
    public boolean applies(IProject project, IPath currentDirectory, IPath indexRoot) {
        return true;
    }

    public static String getModuleId(IParseNode child) {
        JSGetPropertyNode getProp;
        IParseNode right;
        IParseNode node;
        JSInvokeNode invoke;
        if (child instanceof JSInvokeNode && (invoke = (JSInvokeNode)child).getChildCount() == 2 && (node = invoke.getChild(0)) instanceof JSGetPropertyNode && (right = (getProp = (JSGetPropertyNode)node).getRightHandSide()).getNameNode().getName().equals("join")) {
            JSArgumentsNode joinArgs = (JSArgumentsNode)invoke.getChild(1);
            ArrayList<String> items = new ArrayList<String>();
            Iterator iterator = joinArgs.iterator();
            while (iterator.hasNext()) {
                IParseNode joinArg = (IParseNode)iterator.next();
                String arg = CommonJSResolver.getStringValue(joinArg);
                if (arg == null) continue;
                items.add(arg);
            }
            return StringUtil.join((String)"/", items);
        }
        return CommonJSResolver.getStringValue(child);
    }

    private static String getStringValue(IParseNode node) {
        JSIdentifierNode identifier;
        if (node instanceof JSStringNode) {
            JSStringNode string = (JSStringNode)node;
            return StringUtil.stripQuotes((String)string.getText());
        }
        if (node instanceof JSIdentifierNode && (identifier = (JSIdentifierNode)node).getNameNode().getName().equals("__dirname")) {
            return ".";
        }
        return null;
    }

    @Override
    public List<String> getPossibleModuleIds(IProject project, IPath currentDirectory, IPath indexRoot) {
        return null;
    }
}

